DROP TABLE prefix_menu;

CREATE TABLE `prefix_menu` (
  `id` smallint(6) NOT NULL auto_increment,
  `sub` smallint(6) NOT NULL default '0',
  `wo` tinyint(1) NOT NULL default '0',
  `pos` tinyint(4) NOT NULL default '0',
  `was` tinyint(1) NOT NULL default '0',
  `recht` tinyint(2) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_downcats` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_downloads` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  `creater` varchar(250) default NULL,
  `version` varchar(20) default NULL,
  `hits` int(11) NOT NULL default '0',
  `downs` int(11) NOT NULL default '0',
  `url` varchar(100) NOT NULL default '',
  `surl` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) default NULL,
  `descl` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_awaycal` (
  `id` int(14) unsigned NOT NULL auto_increment,
  `nick` char(80) default NULL,
  `uid` tinyint(3) default NULL,
  `pruef` tinyint(2) default '2',
  `von` date default NULL,
  `bis` date default NULL,
  `betreff` char(255) default NULL,
  PRIMARY KEY (`id`)
) TYPE=MyISAM COMMENT='powered by silentforces.de';

CREATE TABLE `prefix_shoutbox` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `nickname` varchar(50) NOT NULL default '',
  `textarea` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_history` (
  `id` smallint(6) NOT NULL auto_increment,
  `date` date NOT NULL default '0000-00-00',
  `title` varchar(100) NOT NULL default '',
  `txt` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_forumcats` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `pos` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_groups` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_groupusers` (
  `uid` mediumint(9) NOT NULL default '0',
  `gid` smallint(6) NOT NULL default '0',
  `fid` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`uid`,`gid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_linkcats` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_links` (
  `id` smallint(6) NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_modulerights` (
  `uogid` mediumint(9) NOT NULL default '0',
  `module` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`uogid`,`module`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_modules` (
  `module` varchar(20) NOT NULL default '',
  `gshow` tinyint(1) NOT NULL default '0',
  `ashow` tinyint(1) NOT NULL default '0',
  `fright` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`module`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_partners` (
  `id` smallint(6) NOT NULL auto_increment,
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_profilefields` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `change` varchar(100) NOT NULL default '',
  `show` varchar(100) NOT NULL default '',
  `pos` int(11) NOT NULL default '0',
  `udel` tinyint(1) NOT NULL default '0',
  `func` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_teams2` (
  `gid` smallint(6) NOT NULL default '0',
  `img` varchar(100) NOT NULL default '',
  `mod` mediumint(9) NOT NULL default '0',
  `pos` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`gid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_usercheck` (
  `check` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `pass` varchar(100) NOT NULL default '',
  `datime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ak` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`check`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_userfields` (
  `uid` mediumint(8) NOT NULL default '0',
  `fid` mediumint(8) NOT NULL default '0',
  `val` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`uid`,`fid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_userfuncs` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `pos` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_warmaps` (
  `wid` smallint(6) NOT NULL default '0',
  `mnr` tinyint(4) NOT NULL default '0',
  `map` varchar(100) NOT NULL default '',
  `opp` smallint(6) NOT NULL default '0',
  `owp` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`wid`,`mnr`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_warmember` (
  `wid` smallint(6) NOT NULL default '0',
  `uid` mediumint(9) NOT NULL default '0',
  `aktion` tinyint(1) NOT NULL default '0',
  `kom` text NOT NULL
) TYPE=MyISAM COMMENT='powered by ilch.de';

INSERT INTO prefix_modules VALUES ('gallery', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('news', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('teams', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('groups', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('rules', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('awards', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('wars', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('forumsite', 0, 0, 1);
INSERT INTO prefix_modules VALUES ('forum', 1, 0, 1);

INSERT INTO prefix_profilefields VALUES (1, 'Wohnort', 'Wohnort', 0, 0, 1);
INSERT INTO prefix_profilefields VALUES (2, 'PrivMsg aktivieren?', 'PrivMsg', 9, 0, 3);
INSERT INTO prefix_profilefields VALUES (3, 'von Usern eMails?', 'eMail', 8, 0, 3);
INSERT INTO prefix_profilefields VALUES (4, 'Homepage', 'Homepage', 10, 0, 1);
INSERT INTO prefix_profilefields VALUES (5, 'Signature', 'Signature', 5, 0, 4);
INSERT INTO prefix_profilefields VALUES (6, 'Avatar', 'Avatar', 6, 0, 2);
INSERT INTO prefix_profilefields VALUES (7, 'ICQ Nummer', 'ICQ Nummer', 11, 0, 1);
INSERT INTO prefix_profilefields VALUES (8, 'Geburtsdatum', 'Geburtsdatum', 1, 0, 1);
INSERT INTO prefix_profilefields VALUES (9, 'Geschlecht', 'Geschlecht', 3, 0, 1);
INSERT INTO prefix_profilefields VALUES (10, 'Nationalitt', 'Nationalitt', 4, 0, 5);
INSERT INTO prefix_profilefields VALUES (11, 'zur Zeit aktiv?', 'Status', 2, 0, 3);
INSERT INTO prefix_profilefields VALUES (12, 'Kontakt', 'Kontakt', 7, 0, 6);

INSERT INTO `prefix_menu` VALUES (1, 1, 1, 0, 2, 0, 'Men', 'allianz.php');
INSERT INTO `prefix_menu` VALUES (2, 2, 1, 10, 2, 0, 'Clan Men', 'allianz.php');
INSERT INTO `prefix_menu` VALUES (3, 3, 1, 19, 1, 0, 'Login', 'login.php');
INSERT INTO `prefix_menu` VALUES (4, 1, 1, 1, 3, 0, 'News', '?m=news');
INSERT INTO `prefix_menu` VALUES (5, 1, 1, 9, 3, 0, 'Links', '?m=links');
INSERT INTO `prefix_menu` VALUES (6, 1, 1, 7, 3, 0, 'Downloads', '?m=downloads');
INSERT INTO `prefix_menu` VALUES (7, 1, 1, 8, 3, 0, 'Gallery', '?m=gallery');
INSERT INTO `prefix_menu` VALUES (8, 1, 1, 2, 3, 0, 'Forum', '?m=forum');
INSERT INTO `prefix_menu` VALUES (9, 1, 1, 3, 3, 0, 'Kontakt', '?m=contact');
INSERT INTO `prefix_menu` VALUES (10, 1, 1, 4, 3, 0, 'Gstebuch', '?m=gbook');
INSERT INTO `prefix_menu` VALUES (11, 2, 1, 12, 3, 0, 'Wars', '?m=wars');
INSERT INTO `prefix_menu` VALUES (13, 2, 1, 16, 3, 0, 'AwayCal', '?m=awaycal');
INSERT INTO `prefix_menu` VALUES (15, 2, 1, 13, 3, 0, 'Awards', '?m=awards');
INSERT INTO `prefix_menu` VALUES (16, 2, 1, 18, 3, 0, 'Fightus', '?m=fightus');
INSERT INTO `prefix_menu` VALUES (17, 2, 1, 17, 3, 0, 'Joinus', '?m=joinus');
INSERT INTO `prefix_menu` VALUES (18, 2, 1, 14, 3, 0, 'Regeln', '?m=rules');
INSERT INTO `prefix_menu` VALUES (20, 2, 1, 11, 3, 0, 'Squads', '?m=teams');
INSERT INTO `prefix_menu` VALUES (21, 1, 1, 6, 3, 0, 'Mitglieder', '?m=user');
INSERT INTO `prefix_menu` VALUES (22, 22, 2, 0, 1, 0, 'Umfrage', 'vote.php');
INSERT INTO `prefix_menu` VALUES (23, 23, 2, 1, 1, 0, 'Allianz', 'allianz.php');
INSERT INTO `prefix_menu` VALUES (24, 24, 2, 2, 1, 0, 'Statistik', 'statistik.php');
INSERT INTO `prefix_menu` VALUES (25, 25, 2, 3, 1, 0, 'Lastwars', 'lastwars.php');
INSERT INTO `prefix_menu` VALUES (26, 26, 2, 4, 1, 0, 'Nextwars', 'nextwars.php');
INSERT INTO `prefix_menu` VALUES (27, 27, 2, 5, 1, 0, 'Newsletter', 'newsletter.php');
INSERT INTO `prefix_menu` VALUES (28, 28, 2, 6, 1, 0, 'Last Forum', 'lastforum.php');
INSERT INTO `prefix_menu` VALUES (29, 29, 2, 7, 1, 0, 'Last News', 'lastnews.php');
INSERT INTO `prefix_menu` VALUES (30, 30, 2, 8, 1, 0, 'Designs', 'designs.php');
INSERT INTO `prefix_menu` VALUES (31, 31, 1, 20, 1, 0, 'Shoutbox', 'shoutbox.php');
INSERT INTO `prefix_menu` VALUES (32, 1, 1, 5, 3, 0, 'Impressum', '?m=impressum');
INSERT INTO `prefix_menu` VALUES (33, 2, 1, 15, 3, 0, 'History', '?m=history');

ALTER TABLE `prefix_user`
  DROP `opm`,
  DROP `omail`,
  DROP `avata`,
  DROP `page`,
  DROP `icq`,
  DROP `msn`,
  DROP `aim`,
  DROP `yahoo`,
  DROP `ort`,
  DROP `geb`,
	DROP `pkey`,
  DROP `style`,
	DROP `rang`,
  DROP `sig`;

INSERT INTO `prefix_allg` VALUES ('', 'impressum', 'Verantwortlich fr diese Seite:', 'Max Mustermann', 'Strasse, Nr', 'PLZ, Ort', '', '', 'Text');

INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_avatar_upload', '1', 'r2', 'Forum Optionen', '', '', 'Avatar Upload?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gallery_imgs_per_site', '12', 't', 'Gallery Optionen', '', '', 'Bilder pro Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gallery_preview_width', '50', 't', 'Gallery Optionen', '', '', 'Breite der Vorschaubilder');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gbook_posts_per_site', '20', 't', 'Gstebuch Optionen', '', '', 'Eintrge pro Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gallery_imgs_per_line', '4', 't', 'Gallery Optionen', '', '', 'Bilder pro Zeile');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'allg_menupoint_access', '1', 'r2', 'Allgemeine Optionen', '', '', 'Zugriff auf nicht im Men verlinkte Module fr alle?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_regist', '1', 'r2', 'Forum Optionen', '', '', 'Drfen sich User registrieren?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_regist_user_pass', '0', 'r2', 'Forum Optionen', '', '', 'Passwort vom User beim registrieren selber whlbar?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_regist_confirm_link', '1', 'r2', 'Forum Optionen', '', '', 'Registrierung per Link im eMail besttigen?');



ALTER TABLE `prefix_news` ADD `date1` DATETIME NOT NULL AFTER `id` ;
UPDATE prefix_news SET date1 = DATE_FORMAT( FROM_UNIXTIME( `time` ) , '%Y-%m-%d %H:%i:%s' );
ALTER TABLE `prefix_news` CHANGE `date1` `news_time` DATETIME NOT NULL;
ALTER TABLE `prefix_news` DROP `time`;
ALTER TABLE `prefix_news` CHANGE `erst` `user_id` INT NOT NULL ;
ALTER TABLE `prefix_news` CHANGE `id` `news_id` INT UNSIGNED NOT NULL AUTO_INCREMENT ;
ALTER TABLE `prefix_news` CHANGE `titel` `news_title` VARCHAR( 100 ) NOT NULL;
ALTER TABLE `prefix_news` CHANGE `kat` `news_kat` VARCHAR( 100 ) NOT NULL;
ALTER TABLE `prefix_news` CHANGE `recht` `news_recht` INT NOT NULL ;
ALTER TABLE `prefix_news` CHANGE `text` `news_text` TEXT NOT NULL ;
ALTER TABLE `prefix_news` DROP `stext`;

UPDATE prefix_news SET news_recht = -5 WHERE news_recht = 1;
UPDATE prefix_news SET news_recht = -3 WHERE news_recht = 2;
UPDATE prefix_news SET news_recht = -1 WHERE news_recht = 3;


ALTER TABLE `prefix_newsletter` DROP `id` ,
DROP `stat` ,
DROP `key` ;

ALTER TABLE `prefix_wars` DROP `tag` ,
DROP `mon` ,
DROP `jahr` ;
ALTER TABLE `prefix_wars` ADD `datime` DATETIME NOT NULL AFTER `id` ;
ALTER TABLE `prefix_wars` ADD `owp` SMALLINT NOT NULL AFTER `wlp` , ADD `opp` SMALLINT NOT NULL AFTER `owp` ;

ALTER TABLE `prefix_forum` RENAME `prefix_forums` ;
ALTER TABLE `prefix_forums` CHANGE `uid` `cid` MEDIUMINT( 8 ) DEFAULT '0' NOT NULL ;

ALTER TABLE `prefix_forums` ADD `last_post_id` INT NOT NULL AFTER `cid`;

ALTER TABLE `prefix_topic` DROP `time` ;
ALTER TABLE `prefix_topic` DROP `last`;
ALTER TABLE `prefix_topic` ADD `last_post_id` MEDIUMINT NOT NULL AFTER `fid` ;
ALTER TABLE `prefix_topic` RENAME `prefix_topics` ;

ALTER TABLE `prefix_wars` CHANGE `team` `tid` SMALLINT NOT NULL;
ALTER TABLE `prefix_forums` CHANGE `recht` `view` TINYINT( 1 ) NOT NULL ;
ALTER TABLE `prefix_forums` ADD `reply` TINYINT( 1 ) NOT NULL AFTER `view` ;
ALTER TABLE `prefix_forums` ADD `start` TINYINT( 1 ) NOT NULL AFTER `reply` ;
ALTER TABLE `prefix_forums` DROP `mods`;
ALTER TABLE `prefix_forums` ADD `mods` TINYINT( 1 ) NOT NULL AFTER `start` ;

UPDATE prefix_forums SET reply = `view`, `start` = `view`, mods = -5;

ALTER TABLE `prefix_rulez` RENAME `prefix_rules` ;
ALTER TABLE `prefix_rules` CHANGE `id` `zahl` SMALLINT DEFAULT '0' NOT NULL;
ALTER TABLE `prefix_rules` ADD `id` SMALLINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST ;

UPDATE prefix_allg SET v2 = 'ilchClan', v1 = 'gfx' WHERE v1 = 'style' AND k = 'ALLG';
UPDATE prefix_allg SET v1 = 'title' WHERE v1 = 'titel' AND k = 'ALLG';
UPDATE prefix_user SET recht = -5 WHERE recht = 1;
UPDATE prefix_user SET recht = -3 WHERE recht = 2;
UPDATE prefix_user SET recht = -1 WHERE recht = 3;
UPDATE prefix_topics SET art = '0' WHERE art = '1';
UPDATE prefix_topics SET art = '1' WHERE art = '2' OR art = '3';

ALTER TABLE `prefix_counter` ADD `date1` DATE NOT NULL FIRST;
UPDATE prefix_counter SET date1 = DATE_FORMAT( FROM_UNIXTIME( `date` ) , '%Y-%m-%d' );
ALTER TABLE `prefix_counter` DROP `date`;
ALTER TABLE `prefix_counter` CHANGE `date1` `date` DATE DEFAULT '0000-00-00' NOT NULL; 