CREATE TABLE `prefix_downcats` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_downloads` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  `creater` varchar(250) default NULL,
  `version` varchar(20) default NULL,
  `hits` int(11) NOT NULL default '0',
  `downs` int(11) NOT NULL default '0',
  `url` varchar(100) NOT NULL default '',
  `surl` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) default NULL,
  `descl` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_forumcats` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `pos` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_groups` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_groupusers` (
  `uid` mediumint(9) NOT NULL default '0',
  `gid` smallint(6) NOT NULL default '0',
  `fid` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`uid`,`gid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_linkcats` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_links` (
  `id` smallint(6) NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_modulerights` (
  `uogid` mediumint(9) NOT NULL default '0',
  `module` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`uogid`,`module`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_modules` (
  `module` varchar(20) NOT NULL default '',
  `gshow` tinyint(1) NOT NULL default '0',
  `ashow` tinyint(1) NOT NULL default '0',
  `fright` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`module`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_partners` (
  `id` smallint(6) NOT NULL auto_increment,
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_profilefields` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `change` varchar(100) NOT NULL default '',
  `show` varchar(100) NOT NULL default '',
  `pos` int(11) NOT NULL default '0',
  `udel` tinyint(1) NOT NULL default '0',
  `func` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_teams2` (
  `gid` smallint(6) NOT NULL default '0',
  `img` varchar(100) NOT NULL default '',
  `mod` mediumint(9) NOT NULL default '0',
  `pos` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`gid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_usercheck` (
  `check` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `pass` varchar(100) NOT NULL default '',
  `datime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ak` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`check`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_userfields` (
  `uid` mediumint(8) NOT NULL default '0',
  `fid` mediumint(8) NOT NULL default '0',
  `val` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`uid`,`fid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_userfuncs` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `pos` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_warmaps` (
  `wid` smallint(6) NOT NULL default '0',
  `mnr` tinyint(4) NOT NULL default '0',
  `map` varchar(100) NOT NULL default '',
  `opp` tinyint(4) NOT NULL default '0',
  `owp` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`wid`,`mnr`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_warmember` (
  `wid` smallint(6) NOT NULL default '0',
  `uid` mediumint(9) NOT NULL default '0',
  `aktion` tinyint(1) NOT NULL default '0',
  `kom` text NOT NULL
) TYPE=MyISAM COMMENT='powered by ilch.de';

INSERT INTO prefix_modules VALUES ('gallery', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('news', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('teams', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('groups', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('rules', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('awards', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('wars', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('forumsite', 0, 0, 1);
INSERT INTO prefix_modules VALUES ('forum', 1, 0, 1);

INSERT INTO prefix_profilefields VALUES (1, 'Wohnort', 'Wohnort', 0, 0, 1);
INSERT INTO prefix_profilefields VALUES (2, 'PrivMsg aktivieren?', 'PrivMsg', 9, 0, 3);
INSERT INTO prefix_profilefields VALUES (3, 'von Usern eMails?', 'eMail', 8, 0, 3);
INSERT INTO prefix_profilefields VALUES (4, 'Homepage', 'Homepage', 10, 0, 1);
INSERT INTO prefix_profilefields VALUES (5, 'Signature', 'Signature', 5, 0, 4);
INSERT INTO prefix_profilefields VALUES (6, 'Avatar', 'Avatar', 6, 0, 2);
INSERT INTO prefix_profilefields VALUES (7, 'ICQ Nummer', 'ICQ Nummer', 11, 0, 1);
INSERT INTO prefix_profilefields VALUES (8, 'Geburtsdatum', 'Geburtsdatum', 1, 0, 1);
INSERT INTO prefix_profilefields VALUES (9, 'Geschlecht', 'Geschlecht', 3, 0, 1);
INSERT INTO prefix_profilefields VALUES (10, 'Nationalitt', 'Nationalitt', 4, 0, 5);
INSERT INTO prefix_profilefields VALUES (11, 'zur Zeit aktiv?', 'Status', 2, 0, 3);
INSERT INTO prefix_profilefields VALUES (12, 'Kontakt', 'Kontakt', 7, 0, 6);

ALTER TABLE `prefix_user`
  DROP `opm`,
  DROP `omail`,
  DROP `avata`,
  DROP `page`,
  DROP `icq`,
  DROP `msn`,
  DROP `aim`,
  DROP `yahoo`,
  DROP `ort`,
  DROP `geb`,
	DROP `pkey`,
  DROP `style`,
	DROP `rang`,
  DROP `sig`;

ALTER TABLE `prefix_news` CHANGE `time` `news_time` DATETIME NOT NULL;
ALTER TABLE `prefix_news` CHANGE `erst` `user_id` INT NOT NULL ;
ALTER TABLE `prefix_news` CHANGE `id` `news_id` INT UNSIGNED NOT NULL AUTO_INCREMENT ;
ALTER TABLE `prefix_news` CHANGE `titel` `news_title` VARCHAR( 100 ) NOT NULL;
ALTER TABLE `prefix_news` CHANGE `kat` `news_kat` VARCHAR( 100 ) NOT NULL;
ALTER TABLE `prefix_news` CHANGE `recht` `news_recht` INT NOT NULL ;
ALTER TABLE `prefix_news` CHANGE `text` `news_text` TEXT NOT NULL ;
ALTER TABLE `prefix_news` DROP `stext`;

ALTER TABLE `prefix_newsletter` DROP `id` ,
DROP `stat` ,
DROP `key` ;

ALTER TABLE `prefix_wars` DROP `tag` ,
DROP `mon` ,
DROP `jahr` ;
ALTER TABLE `prefix_wars` ADD `datime` DATETIME NOT NULL AFTER `id` ;
ALTER TABLE `prefix_wars` ADD `owp` SMALLINT NOT NULL AFTER `wlp` , ADD `opp` SMALLINT NOT NULL AFTER `owp` ;

ALTER TABLE `prefix_forum` RENAME `prefix_forums` ;
ALTER TABLE `prefix_forums` CHANGE `uid` `cid` MEDIUMINT( 8 ) DEFAULT '0' NOT NULL ;

ALTER TABLE `prefix_forums` ADD `last_post_id` INT NOT NULL AFTER `cid`;

ALTER TABLE `prefix_topic` DROP `time` ;
ALTER TABLE `prefix_topic` DROP `last`;
ALTER TABLE `prefix_topic` ADD `last_post_id` MEDIUMINT NOT NULL AFTER `fid` ;
ALTER TABLE `prefix_topic` RENAME `prefix_topics` ;

ALTER TABLE `prefix_forums` CHANGE `recht` `view` TINYINT( 1 ) NOT NULL ;
ALTER TABLE `prefix_forums` ADD `reply` TINYINT( 1 ) NOT NULL AFTER `view` ;
ALTER TABLE `prefix_forums` ADD `start` TINYINT( 1 ) NOT NULL AFTER `reply` ;
ALTER TABLE `prefix_forums` DROP `mods`;
ALTER TABLE `prefix_forums` ADD `mods` TINYINT( 1 ) NOT NULL AFTER `start` ;

UPDATE prefix_forums SET reply = `view`, `start` = `view`, mods = -5;

ALTER TABLE `prefix_rulez` RENAME `prefix_rules` ;

UPDATE prefix_allg SET v2 = 'ilchClan', v1 = 'gfx' WHERE v1 = 'style' AND k = 'ALLG';
UPDATE prefix_allg SET v1 = 'title' WHERE v1 = 'titel' AND k = 'ALLG';
UPDATE prefix_user SET recht = -5 WHERE recht = 1;
UPDATE prefix_user SET recht = -3 WHERE recht = 2;
UPDATE prefix_user SET recht = -1 WHERE recht = 3;
UPDATE prefix_menu SET link = 'designs.php' WHERE link = 'templates.php';
UPDATE prefix_menu SET recht = '0';
UPDATE prefix_topics SET art = '0' WHERE art = '1';
UPDATE prefix_topics SET art = '1' WHERE art = '2' OR art = '3';