<?php 
#   Copyright by Manuel Staechele
#   Support www.ilch.de


defined ('main') or die ( 'no direct access' );
function BBcode($s,$maxLength=75) {

  $coTime = str_replace(' ', '', microtime());
	preg_match_all('/\[code\](.+)\[\/code\]/Uis',$s,$result);
  $s = bbcode_code_start ($s, $coTime, $result);
	$s = preg_replace("/\&lt\;(\/)?textarea(.*?)\&gt\;/Ui","<\\1textarea\\2>", $s);
  $s = htmlentities($s);
  
	#$s = stripslashes($s);
  $s = unescape($s);
  $s = preg_replace ("/\015\012|\015|\012/", " <br />\n", $s);
  
  
  # speziell bilder
  $s = bbcode_images ($s);
  
  # speziell zitate ersetzten.
  $s = bbcode_quote ($s);
  
  # replace simple
	$s = bbcode_simple ($s);
  
  # autoumbruch nach x zeichen
  $s = bbcode_autonewline($s, $coTime, $maxLength);
	
	# smilies umwandeln
	$s = bbcode_smiles ($s);
	
  # code zurueck ersetzten
  $s = bbcode_code_end ($s, $coTime, $result);
	
	return $s;
}

function bbcode_autonewline ($s, $coTime,$maxLength) {
	$s = str_replace('</a>', ' </a>', $s);
  $lines = explode(' ',$s);
  
	$ntxt = '';
	foreach ($lines as $v) {
	  if ( strpos($v,$coTime) === FALSE AND strpos ($v, 'src="') === FALSE AND strpos ($v, 'href="') === FALSE AND strpos ($v, '</table>') === FALSE) {
		  $ntxt .= chunk_split($v, $maxLength, ' ').' ';
    } else {
		  $ntxt .= $v.' ';
		}
	}
	$s = $ntxt;
  $s = str_replace(' </a>', '</a>', $s);
  return($s);
}

function bbcode_images ($s) {
  preg_match_all('/\[img\](.*?)\[\/img\]/Ui',$s,$imgRs);
  if ( isset ($imgRs[0][0]) ) {
    for($i=0;$i<count($imgRs[0]);$i++) {
  	  $size       = @getimagesize($imgRs[1][$i]);
	    $breite     = $size[0];
      $hoehe      = $size[1];
      $neueHoehe  = $hoehe;
      $neueBreite = $breite;
      if ( $breite > 500 ) {
        $neueHoehe=intval($hoehe*500/$breite);
        $neueBreite = 500;
      }
      $s = str_replace($imgRs[0][$i],'<a href="'.$imgRs[1][$i].'" target="_blank"><img height="'.$neueHoehe.'" width="'.$neueBreite.'" style="border: none;" src="'.$imgRs[1][$i].'" /></a>',$s);
    }
  }
  return($s);
}

function bbcode_quote ($s) {
 	$tpl = new tpl ( 'zitatreplace.htm' );
	$header1_quote = $tpl->get(0);
	$header2_quote = $tpl->get(1);
	$footer1_quote = $tpl->get(2);
	unset($tpl);
  $i=0;
  while(strpos($s,"[/quote]")!==FALSE AND $i < 5 ) {
    $i++;
    $s = preg_replace("#\[quote\=([^\]]*)\](.*)\[\/quote\]#Uis",$header1_quote."geschrieben von \\1".$header2_quote."\\2".$footer1_quote, $s);
    $s = preg_replace("/\[quote\](.*)\[\/quote\]/Usi", $header1_quote.$header2_quote."\\1".$footer1_quote, $s );
  }
  return ($s);
}

function bbcode_simple ($s) {
  $search = array (
    "/\[b\](.*?)\[\/b\]/si",
    "/\[i\](.*?)\[\/i\]/si",
    "/\[u\](.*?)\[\/u\]/si",
    "/\[url\]http:\/\/(.*?)\[\/url\]/si",
    "/\[url\](.*?)\[\/url\]/si",
    "/\[iurl\](.*?)\[\/iurl\]/si",
    "/\[url=http:\/\/(.*?)\](.*?)\[\/url\]/si",
    "/\[url=(.*?)\](.*?)\[\/url\]/si",
    "/\[iurl=(.*?)\](.*?)\[\/iurl\]/si",
    "/\[\*\](.*?)/Ui",
    "/\[list\](.*?)\[\/list\]/si",
    "/[^\]>\"](ftp|http|https){1}\:\/\/([^\"\s\<\[]*)/i" ,
    "/[^\]>\"|http\:\/\/]www\.([^\s\"\<\[]*)/i"
	);
  
	$replace = array (
    "<b>\\1</b>",
    "<i>\\1</i>",
    "<u>\\1</u>",
    "<a href=\"http://\\1\" target=\"_blank\">\\1</a>",
    "<a href=\"http://\\1\" target=\"_blank\">\\1</a>",
    "<a target=\"_self\" href=\"\\1\">\\1</a>",
    "<a href=\"http://\\1\" target=\"_blank\">\\2</a>",
    "<a href=\"http://\\1\" target=\"_blank\">\\2</a>",
    "<a target=\"_self\" href=\"\\1\">\\2</a>",
    "<li>\\1</li>",
    "<ul>\\1</ul>",
    " <a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a> ",
    " <a href=\"http://www.\\1\" target=\"_blank\">www.\\1</a> "
	);
						
	$s = preg_replace($search, $replace, $s);
  return ($s);
}

function bbcode_smiles ($s) {
  global $global_smiles_array;
  if (!isset($global_smiles_array)) {
    $global_smiles_array = array();
    $erg = db_query('SELECT * FROM `prefix_smilies`');
	  while ($row = db_fetch_object($erg) ) {
		  $global_smiles_array[$row->ent] = $row->url;
	  }
  }
  foreach ($global_smiles_array as $k => $v) {
    $s = str_replace($k,'<img src="'.$v.'" border="0" alt="'.$k.'" title="'.$k.'" />',$s);
  }
  return ($s);
}

function bbcode_code_start ($s, $coTime, $result) {
	for ($i=0;$i<count($result[1]);$i++) 	{
		if ($result[0][$i]) {
		  $s = str_replace ($result[0][$i],'#'.$coTime.'#'.$i.'#'.$coTime.'#',$s);
		}
	}
  return ($s);
}

function bbcode_code_end ($s, $coTime, $result) {
	$tpl = new tpl ( 'codereplace.htm' );
	for ($i=0;$i<count($result[1]);$i++) {
		if ($result[1][$i]) {
			ob_start();
			$result[1][$i] = str_replace ('&lt;', '<', str_replace('&gt;', '>', $result[1][$i]));
      highlight_string(trim($result[1][$i]));
			$codereplace = ob_get_contents();
			ob_end_clean();
			$newstring = $tpl->set_get ( 'CODEREPLACE', $codereplace, 0);
			$s = str_replace('#'.$coTime.'#'.$i.'#'.$coTime.'#',$newstring,$s);
		}
	}
	unset($tpl);
  return ($s);
}
?>