<?php
/**
 * @copyright Ilch 2.0
 * @package ilch
 */

namespace Modules\Comment\Mappers;

use Modules\Comment\Models\Comment as CommentModel;

class Comment extends \Ilch\Mapper
{
    /**
     * @return CommentModel[]
     */
    public function getCommentsByKey($key)
    {
        $commentsArray = $this->db()->select('*')
            ->from('comments')
            ->where(['key' => $key])
            ->order(['id' => 'DESC'])
            ->execute()
            ->fetchRows();

        $comments = [];
        foreach ($commentsArray as $commentRow) {
            $commentModel = new CommentModel();
            $commentModel->setId($commentRow['id']);
            $commentModel->setFKId($commentRow['fk_id']);
            $commentModel->setKey($commentRow['key']);
            $commentModel->setText($commentRow['text']);
            $commentModel->setUserId($commentRow['user_id']);
            $commentModel->setDateCreated($commentRow['date_created']);
            $commentModel->setUp($commentRow['up']);
            $commentModel->setDown($commentRow['down']);
            $commentModel->setVoted($commentRow['voted']);
            $comments[] = $commentModel;
        }

        return $comments;
    }

    public function getCommentsLikeKey($key)
    {
        $sql = 'SELECT *
                FROM `[prefix]_comments`
                WHERE `key` LIKE "'.$key.'%"
                ORDER BY `id` DESC';

        $commentsArray = $this->db()->queryArray($sql);

        $comments = [];
        foreach ($commentsArray as $commentRow) {
            $commentModel = new CommentModel();
            $commentModel->setId($commentRow['id']);
            $commentModel->setFKId($commentRow['fk_id']);
            $commentModel->setKey($commentRow['key']);
            $commentModel->setText($commentRow['text']);
            $commentModel->setUserId($commentRow['user_id']);
            $commentModel->setDateCreated($commentRow['date_created']);
            $commentModel->setUp($commentRow['up']);
            $commentModel->setDown($commentRow['down']);
            $commentModel->setVoted($commentRow['voted']);
            $comments[] = $commentModel;
        }

        return $comments;
    }

    public function getCommentById($id)
    {
        $commentRow = $this->db()->select('*')
            ->from('comments')
            ->where(['id' => $id])
            ->execute()
            ->fetchAssoc();

        if (empty($commentRow)) {
            return null;
        }

        $commentModel = new CommentModel();
        $commentModel->setId($commentRow['id']);
        $commentModel->setFKId($commentRow['fk_id']);
        $commentModel->setKey($commentRow['key']);
        $commentModel->setText($commentRow['text']);
        $commentModel->setUserId($commentRow['user_id']);
        $commentModel->setDateCreated($commentRow['date_created']);
        $commentModel->setUp($commentRow['up']);
        $commentModel->setDown($commentRow['down']);
        $commentModel->setVoted($commentRow['voted']);

        return $commentModel;
    }
	
    public function getCommentsByFKid($key)
    {
        $commentsArray = $this->db()->select('*')
            ->from('comments')
            ->where(['fk_id' => $key])
            ->order(['id' => 'DESC'])
            ->execute()
            ->fetchRows();

        $comments = [];
        foreach ($commentsArray as $commentRow) {
            $commentModel = new CommentModel();
            $commentModel->setId($commentRow['id']);
            $commentModel->setFKId($commentRow['fk_id']);
            $commentModel->setKey($commentRow['key']);
            $commentModel->setText($commentRow['text']);
            $commentModel->setUserId($commentRow['user_id']);
            $commentModel->setDateCreated($commentRow['date_created']);
            $commentModel->setUp($commentRow['up']);
            $commentModel->setDown($commentRow['down']);
            $commentModel->setVoted($commentRow['voted']);
            $comments[] = $commentModel;
        }

        return $comments;
    }

    /**
     * @return CommentModel[]
     */
    public function getComments()
    {
        $commentsArray = $this->db()->select('*')
            ->from('comments')
            ->order(['id' => 'DESC'])
            ->execute()
            ->fetchRows();

        $comments = [];
        foreach ($commentsArray as $commentRow) {
            $commentModel = new CommentModel();
            $commentModel->setId($commentRow['id']);
            $commentModel->setFKId($commentRow['fk_id']);
            $commentModel->setKey($commentRow['key']);
            $commentModel->setText($commentRow['text']);
            $commentModel->setUserId($commentRow['user_id']);
            $commentModel->setDateCreated($commentRow['date_created']);
            $commentModel->setUp($commentRow['up']);
            $commentModel->setDown($commentRow['down']);
            $commentModel->setVoted($commentRow['voted']);
            $comments[] = $commentModel;
        }

        return $comments;
    }
    
    /**
     * Gets the counter of all comments with given $key.
     *
     * @return integer
     */
    public function getCountComments($key)
    {
        $sql = 'SELECT COUNT(*)
                FROM `[prefix]_comments`
                WHERE `key` LIKE "'.$key.'%"';

        $count = $this->db()->queryCell($sql);

        return $count;
    }

    /**
     * Save comment like.
     *
     * @param CommentModel $comment
     */
    public function saveLike(CommentModel $comment)
    {
        $fields = [
            'down' => $comment->getDown(),
            'up' => $comment->getUp(),
            'voted' => $comment->getVoted()
        ];

        $this->db()->update('comments')
            ->values($fields)
            ->where(['id' => $comment->getId()])
            ->execute();
    }

    /**
     * @param CommentModel $comment
     */
    public function save(CommentModel $comment)
    {
        $this->db()->insert('comments')
            ->values
            (
                [
                    'key' => $comment->getKey(),
                    'text' => $comment->getText(),
                    'date_created' => $comment->getDateCreated(),
                    'user_id' => $comment->getUserId(),
                    'fk_id' => $comment->getFKId(),
                ]
            )
            ->execute();
    }

    /**
     * @param integer $id
     */
    public function delete($id)
    {
        do {
            $this->db()->delete('comments')
                ->where(['id' => $id])
                ->execute();
            $id = $this->getCommentIdbyFKid($id);
        } while($id);
    }

    /**
     * Delete comment with given $key
     *
     * @param string $key
     */
    public function deleteByKey($key)
    {
        $sql = 'DELETE FROM `[prefix]_comments`
                WHERE `key` LIKE "'.$key.'%"';

        $this->db()->query($sql);
    }

    /**
     * Get the id of a comment with a specific fk_id.
     *
     * @param integer $fk_id
     * @return integer $id
     */
    public function getCommentIdbyFKid($fk_id) {
        return $this->db()->select('id', 'comments', ['fk_id' => $fk_id])
            ->execute()
            ->fetchCell();
    }
}
