/**
    Statistik Modul von Felix Hohlwegler

    Support unter www.felix-hohlwegler.de

    Version 1.2

*/

AmCharts.ready(function () {   
    // bersicht dieser Monat
    gengraph("Tagediesrmonat",BesuchernachTagen,"chartTagediesrmonat","wert",0);
    genpie("Osdiesrmonat",BesuchernachBetriebssytemen,"chartOsdiesrmonat");
    genpie("Uhrzeitdiesrmonat",BesuchernachUhrzeit,"chartUhrzeitdiesrmonat");
    genpie("Wochentagendiesrmonat",BesuchernachWochentagen,"chartWochentagendiesrmonat");
    genbalken("Browserdiesrmonat",BesuchernachBrowsern,"chartBrowserdiesrmonat");
    genbalken("Herkunftdiesrmonat",BesuchernachHerkunft,"chartHerkunftdiesrmonat");
    
    // bersicht Letzer-Monat
    gengraph("Tageletztermonat",BesuchernachTagenLetzterMonat,"chartTageletztermonat","wert",0);
    genpie("Osletztermonat",BesuchernachBetriebssytemenLetzterMonat,"chartOsletztermonat");
    genpie("Uhrzeitletztermonat",BesuchernachUhrzeitLetzterMonat,"chartUhrzeitletztermonat");
    genpie("Wochentagenletztermonat",BesuchernachWochentagenLetzterMonat,"chartWochentagenletztermonat");
    genbalken("Browserletztermonat",BesuchernachBrowsernLetzterMonat,"chartBrowserletztermonat");
    genbalken("Herkunftletztermonat",BesuchernachHerkunftLetzterMonat,"chartHerkunftletztermonat");
    
    // bersicht ber die Seitenzugriffe
    genbalken("ContentStatistikDieserMonats",ContentStatistikDieserMonat,"chartSeitenStatistikDieserMonat");
    genbalken("SeitenStatistikLetzter",ContentStatistikLetzter,"chartSeitenStatistikLetzter");
    
    // Generiert die bersicht ber Alle Zugriffe
    gengraph("komplett",komplett,"komplettchart","datum",90);
    
    // Generiert die Jahresbersicht
    gengraph("jahre",chartDataJahre,"chartjahre","datum",90);
});


// Generiet eine Kurve
// name = Name des Graphen
// input = JSonay Input
// out = Ausgabe Punkt nach ID
// category = Label beschriftungs kategory (JSON erster wert)
// orientierung = Label orientierung -> 0 = normal -> 90 um 90 gedreht
function gengraph (name, input, out, category, orientierung){
    
    var chart = "chart"+name;
    var graph = "graph"+name;
    var cataxis = "cataxis"+name;
    var valaxis = "valaxis"+name;
    var cursor = "cursor"+name;
    var scorllbar = "scorllbar"+name;
    
    chart = new AmCharts.AmSerialChart();
    chart.pathToImages = "include/extras/amcharts/images/";
    chart.marginRight = 10;
    chart.dataProvider = input;
    chart.categoryField = category;
    chart.dataDateFormat = "YYYY";
    // category
    var cataxis = chart.categoryAxis;
    cataxis.dashLength = 3;
    cataxis.minorGridEnabled = true;
    cataxis.minorGridAlpha = 1;
    cataxis.labelRotation = orientierung;
    // VALUE
    var valaxis = new AmCharts.ValueAxis();
    valaxis.axisAlpha = 0;
    valaxis.inside = false;
    valaxis.dashLength = 3;
    chart.addValueAxis(valaxis);
    // GRAPH
    graph = new AmCharts.AmGraph();
    graph.type = "smoothedLine"; // this line makes step BesuchernachTagenGraph
    graph.lineColor = "#08C";
    graph.bullet = "round";
    graph.bulletSize = 8;
    graph.bulletBorderColor = "#FFFFFF";
    graph.bulletBorderAlpha = 1;
    graph.bulletBorderThickness = 2;
    graph.lineThickness = 2;
    graph.valueField = "summe";
    graph.balloonText = "[[category]]<br><b><span style='font-size:14px;'>[[value]] Zurgiffe</span></b>";
    chart.addGraph(graph);
    // CURSOR
    var cursor = new AmCharts.ChartCursor();
    cursor.cursorAlpha = 0;
    cursor.cursorPosition = "mouse";
    cursor.categoryBalloonDateFormat = "YYYY";
    chart.addChartCursor(cursor);
    // SCROLLBAR
    var scorllbar = new AmCharts.ChartScrollbar();
    chart.addChartScrollbar(scorllbar);
    chart.creditsPosition = "bottom-right";
    // WRITE
    chart.write(out);
}

// Generiert ein Kuchendiagramm
// name = Name des Graphen
// input = JSonay Input
// out = Ausgabe Punkt nach ID
function genpie(name, input, out){   
    var pie = "pie"+name;
    
    pie = new AmCharts.AmPieChart();
    pie.dataProvider = input;
    pie.titleField = "wert";
    pie.valueField = "summe";
    pie.sequencedAnimation = true;
    pie.startEffect = "elastic";
    pie.innerRadius = "30%";
    pie.startDuration = 2;
    pie.labelRadius = 15;
    pie.balloonText = "[[title]]<br><span style='font-size:14px'><b>[[value]]</b> ([[percents]]%)</span>";
    // the following two lines makes the chart 3D
    pie.depth3D = 10;
    pie.angle = 15;
    pie.creditsPosition = "bottom-right";
    // WRITE                                 
    pie.write(out);
}


// GEneriert ein Sulendiagramm
// name = Name des Graphen
// input = JSonay Input
// out = Ausgabe Punkt nach ID
function genbalken(name, input, output){    
    var balken = "balkenchart"+name;
    var balkengraph = "blakengraph"+name;
    var balkencataxis = "balkencataxis"+name;
    var balkenvalaxis = "balkenvalaxis"+name;
    var balkenlegend = "balkenlegend"+name;
   
    // SERIAL CHART
    balken = new AmCharts.AmSerialChart();
    balken.dataProvider = input;
    balken.categoryField = "wert";
    balken.startDuration = 1;
    balken.rotate = true;
    // AXES
    // category
    var balkencataxis = balken.categoryAxis;
    balkencataxis.gridPosition = "start";
    balkencataxis.axisColor = "#DADADA";
    balkencataxis.dashLength = 3;

    // value
    var balkenvalaxis = new AmCharts.ValueAxis();
    balkenvalaxis.dashLength = 3;
    balkenvalaxis.axisAlpha = 0.2;
    balkenvalaxis.position = "top";
    balkenvalaxis.minorGridEnabled = true;
    balkenvalaxis.minorGridAlpha = 0.08;
    balkenvalaxis.gridAlpha = 0.15;
    balken.addValueAxis(balkenvalaxis);

    // GRAPHS
    // column graph
    var balkengraph = new AmCharts.AmGraph();
    balkengraph.type = "column";
    balkengraph.title = "Anzahl Nutzer";
    balkengraph.valueField = "summe";
    balkengraph.lineAlpha = 0;
    balkengraph.fillColors = "#08C";
    balkengraph.fillAlphas = 0.8;
    balkengraph.balloonText = "<span style='font-size:13px;'>[[title]] in [[category]]:<b>[[value]]</b></span>";
    balken.addGraph(balkengraph);

    // LEGEND
    var balkenlegend = new AmCharts.AmLegend();
    balkenlegend.useGraphSettings = true;
    balken.addLegend(balkenlegend);
    balken.creditsPosition = "top-right";
    // WRITE
    balken.write(output);
}