<?php

#   Copyright 	by: Felix Hohlwegler
#   Support: 	www.felix-hohlwegler.de
# 	Version 	1.2
#	Datum:		09.10.2014

$tpl = new tpl('modernstatistik', 1);

defined('main') or die('no direct access');
defined('admin') or die('only admin access');

$design = new design('Admins Area', 'Admins Area', 2);
$design->header();

// Monat und VorMonat holen
$mon = date('n');
$lastmon = $mon - 1;

if ($menu->exists('botson')) {
    $botWHERE = "";
    $botLink = "admin.php?modernstatistik";
    $botLinkText = "Bots ausblenden";
    
} else {
    // Where Klausel um die Bots auszuschlieen
    $botWHERE = " AND `os` != '0' AND `browser` != '0'";
    $botLink = "admin.php?modernstatistik-botson";
    $botLinkText = "Bots mit anzeigen";
}

$tpl->out(1);

/* --------------------------------------------------------------------------------
 * Abfrage fr diesen Monat und letzten Monat gibt die gesamt - Anzahl aller Zugriffe zurck
 * --------------------------------------------------------------------------------
 */
$gesDieserMonat = db_result(db_query("SELECT COUNT(*) FROM prefix_stats WHERE mon = " . $mon.$botWHERE), 0, 0);
$gesLetzterMonat = db_result(db_query("SELECT COUNT(*) FROM prefix_stats WHERE mon = " . $lastmon.$botWHERE), 0, 0);
echo '<br /><br /><b>Gesamt diesen Monat: ' . $gesDieserMonat . '</b> | Gesamt letzter Monat: ' . $gesLetzterMonat . ' | <a href="'.$botLink.'">'.$botLinkText.'</a>';
/* --------------------------------------------------------------------------------
 * Abfrage fr diesen Monat
 * --------------------------------------------------------------------------------
 */
statistik('BesuchernachTagen', 'day', $mon.$botWHERE, "prefix_stats", "schl DESC LIMIT 50");
statistik('BesuchernachWochentagen', 'DAYNAME(FROM_UNIXTIME((wtag+3)*86400))', $mon.$botWHERE, "prefix_stats", "wtag DESC LIMIT 50");
statistik('BesuchernachUhrzeit', 'stunde', $mon.$botWHERE, "prefix_stats", "schl ASC LIMIT 50");
statistik('BesuchernachBrowsern', 'browser', $mon.$botWHERE, "prefix_stats", "schl DESC LIMIT 50");
statistik('BesuchernachBetriebssytemen', 'os', $mon.$botWHERE, "prefix_stats", "schl DESC LIMIT 50");
statistik('BesuchernachHerkunft', 'ref', $mon.$botWHERE, "prefix_stats", "wert DESC LIMIT 50");

/* --------------------------------------------------------------------------------
 * Abfrage fr letzten Monat
 * --------------------------------------------------------------------------------
 */
statistik('BesuchernachTagenLetzterMonat', 'day', $lastmon.$botWHERE, "prefix_stats", "schl DESC LIMIT 50");
statistik('BesuchernachWochentagenLetzterMonat', 'DAYNAME(FROM_UNIXTIME((wtag+3)*86400))', $lastmon.$botWHERE, "prefix_stats", "wtag DESC LIMIT 50");
statistik('BesuchernachUhrzeitLetzterMonat', 'stunde', $lastmon.$botWHERE, "prefix_stats", "schl ASC LIMIT 50");
statistik('BesuchernachBrowsernLetzterMonat', 'browser', $lastmon.$botWHERE, "prefix_stats", "schl DESC LIMIT 50");
statistik('BesuchernachBetriebssytemenLetzterMonat', 'os', $lastmon.$botWHERE, "prefix_stats", "schl DESC LIMIT 50");
statistik('BesuchernachHerkunftLetzterMonat', 'ref', $lastmon.$botWHERE, "prefix_stats", "wert DESC LIMIT 50");


/* --------------------------------------------------------------------------------
 * Content-Statistik-Abfrage fr diesen
 * --------------------------------------------------------------------------------
 */
statistik('ContentStatistikDieserMonat', 'content', $mon.$botWHERE, "prefix_stats_content", "schl DESC");

statistik('ContentStatistikLetzter', 'content', $lastmon.$botWHERE, "prefix_stats_content", "schl DESC");

/* --------------------------------------------------------------------------------
 * Abfrage fr diesen Monat und fr den Vormonat
 * --------------------------------------------------------------------------------
 */
function statistik($title, $col, $smon, $table, $orderQuery) {
    // Query das ausgefhrt wird
    $sql = db_query("SELECT COUNT(*) AS wert, $col as schl FROM  `".$table."` WHERE mon = " . $smon . " GROUP BY schl ORDER BY " . $orderQuery);
    // Zhlt alle Eintrge
    $summeallerergebnisse = mysql_num_rows(db_query("SELECT COUNT(*) AS wert, $col as schl FROM  `".$table."` WHERE mon = " . $smon . " GROUP BY schl ORDER BY " . $orderQuery));
    $countwerte = 0;
    echo'<script type="text/javascript"> var ' . $title . ' = [';
    
    while ($r = db_fetch_assoc($sql)) {
        $wert = ( empty($r['wert']) ? 1 : $r['wert'] );
        $name = $r['schl'];
        if (strlen($name) >= 50) {
            $name = substr($name, 0, 50) . '<b>...</b>';
        }

        echo '{"wert": "' . $name . '", "summe": ' . $wert . '}';
        $countwerte++;
        if ($countwerte < $summeallerergebnisse) {
            echo ',';
        }
    }
    echo '];</script>';
}


/* --------------------------------------------------------------------------------
 * Abfrage fr die 5 Monats bersicht
 * --------------------------------------------------------------------------------
 */

// Zhlt alle Eintrge
$summealler = mysql_num_rows(db_query("SELECT `count` as sum, DATE_FORMAT(`date`, '%d.%m.%Y') as datum FROM prefix_counter ORDER BY `date` DESC"));

// Counter auf Null
$count = 0;
$erg = db_query("SELECT `count` as sum, DATE_FORMAT(`date`, '%d.%m.%Y') as datum FROM prefix_counter ORDER BY `date` DESC");
echo'<script type="text/javascript">var komplett = [';
while ($r = db_fetch_assoc($erg)) {
    echo '{"datum": "' . $r['datum'] . '", "summe": ' . $r['sum'] . '}';
    $count++;
    if ($count < $summealler) {
        echo ',';
    }
}
echo '];</script>';

/* --------------------------------------------------------------------------------
 * Abfrage fr die Jahres bersicht
 * --------------------------------------------------------------------------------
 */
$ergjahre = db_query("SELECT SUM(`count`) as sum, YEAR(`date`) as jahr FROM prefix_counter GROUP BY jahr ORDER BY jahr DESC");
$summeallerjahre = mysql_num_rows(db_query("SELECT SUM(`count`) as sum, YEAR(`date`) as jahr FROM prefix_counter GROUP BY jahr ORDER BY jahr DESC"));

$count1 = 0;
echo'<script type="text/javascript">var chartDataJahre = [';
while ($r = db_fetch_assoc($ergjahre)) {
    echo '{"datum": "' . $r['jahr'] . '", "summe": ' . $r['sum'] . '}';
    $count1++;
    if ($count1 < $summeallerjahre) {
        echo ',';
    }
}
echo '];</script>';

$tpl->out(2);

$alleZugriffe = db_result(db_query("SELECT SUM(`count`) as sum, YEAR(`date`) as jahr FROM prefix_counter"), 0, 0);

echo '<br><br><b>Zugriffe insgesammt: '.$alleZugriffe.'</b>';
$tpl->out(3);

$design->footer();
?>