<?php
#   Gegnerstatistik by Lord|Schirmer
#   Support: www.ilch.de
 
defined ('main') or die ('no direct access');

# Funktion Ergebnisname
function wlpname($erg) {
	if ($erg == 1) {$name = 'gewonnen';}
	elseif ($erg == 2) {$name = 'verloren';}
	else {$name = 'unentschieden';}
	return $name;
}
# Funktion Bar-Grafik
function get_ergbar ($wir, $gegner) {
	$gesanz = $wir + $gegner;
	if ($wir == 0) {
		$x = '<div title="0%" style="width:206px; text-align:left; height:12px; padding:2px; background:#FFF url(include/images/bars/bg.png); border: 1px #CCC solid; border-radius: 2px; -moz-border-radius: 2px; -webkit-border-radius: 2px; margin:1px;"><img src="include/images/bars/left_red.gif" style="height:12px; width:3px" /><img src="include/images/bars/middle_red.gif" style="height:12px; width:200px" /><img src="include/images/bars/right_red.gif" style="height:12px; width:3px" /></div>';
	} elseif ($gegner == 0) {
		$x = '<div title="100%" style="width:206px; text-align:left; height:12px; padding:2px; background:#FFF url(include/images/bars/bg.png); border: 1px #CCC solid; border-radius: 2px; -moz-border-radius: 2px; -webkit-border-radius: 2px; margin:1px;"><img src="include/images/bars/left_green.gif" style="height:12px; width:3px" /><img src="include/images/bars/middle_green.gif" style="height:12px; width:200px" /><img src="include/images/bars/right_green.gif" style="height:12px; width:3px" /></div>';
	} else {
		$proz = number_format(round($wir/$gesanz*100,1),1,",",".");
		$win = 2 * $proz;
		$los = 200 - $win;
		$x = '<div title="'.$proz.'%" style="width:206px; text-align:left; height:12px; padding:2px 3px 3px 3px; background:#FFF url(include/images/bars/bg.png); border: 1px #CCC solid; border-radius: 2px; -moz-border-radius: 2px; -webkit-border-radius: 2px; margin:1px;"><img src="include/images/bars/left_green.gif" style="height:12px; width:3px" /><img src="include/images/bars/middle_green.gif" style="height:12px; width:'.$win.'px" /><img src="include/images/bars/middle_red.gif" style="height:12px; width:'.$los.'px" /><img src="include/images/bars/right_red.gif" style="height:12px; width:3px" /></div>';
	}
	return($x);
}
# Funktion Bar-Farb-Grafik
function get_colbar ($anz,$gesanz,$farbe='red') {
	$breite = 2; // fach von 100
	$width = $breite*100+6;
	if 		($farbe == 'red') 		{$farbe = 'red';} 
	elseif 	($farbe == 'blue') 		{$farbe = 'blue';} 	
	elseif 	($farbe == 'green') 	{$farbe = 'green';} 
	elseif 	($farbe == 'yellow') 	{$farbe = 'yellow';}
	else 							{$farbe = 'grey';}
	if ($anz == 0 or $gesanz == 0) {
		$x = '<div title="0%" style="width:'.$width.'px; text-align:left; height:12px; padding:2px; background:#FFF url(include/images/bars/bg.png); border: 1px #CCC solid; border-radius: 2px; -moz-border-radius: 2px; -webkit-border-radius: 2px; margin:1px;"></div>';
	} else {
		$proz = number_format(round($anz/$gesanz*100,1),1,",",".");
		$proz2 = round($anz/$gesanz*100,0)*$breite;
		$x = '<div title="'.$proz.' %" style="width:'.$width.'px; text-align:left; height:12px; padding:2px; background:#FFF url(include/images/bars/bg.png); border: 1px #CCC solid; border-radius: 2px; -moz-border-radius: 2px; -webkit-border-radius: 2px; margin:1px;"><img src="include/images/bars/left_'.$farbe.'.gif" style="height:12px; width:3px" /><img src="include/images/bars/middle_'.$farbe.'.gif" style="height:12px; width:'.$proz2.'px" /><img src="include/images/bars/right_'.$farbe.'.gif" style="height:12px; width:3px" /></div>';
	}
	return($x);
}
# Anzeige Detail eines Gegners
if($menu->exists('details')) {
	# Übername Gegner aus URL
	$name = escape($_SERVER["REQUEST_URI"],'string');
	$name = explode('gegner-details-',$name);
    $name = urldecode($name[1]);
	# Header
	$title = $allgAr['title'].' :: Gegner Statistik :: '.$name;
	$hmenu = '<a class="smalfont" href="index.php?gegner">Gegner Statistik</a> <b> &raquo; </b> '.$name;
	$design = new design ( $title , $hmenu, 1); 
	$design->header();
	$tpl = new tpl ( 'gegner.htm' );  
	# DB Abfrage
	$erg = db_query('SELECT *, DATE_FORMAT(`datime`,"%d.%m.%Y") as datum, DATE_FORMAT(`datime`,"%H:%i") as zeit FROM `prefix_wars` WHERE `status` = 3 AND `gegner` = "'.$name.'" ORDER BY `datime` DESC');
	if (db_num_rows($erg) == 0) {
		wd('index.php?gegner','Dieser Gegner wurde nicht gefunden.',3);
	} else {
		# Info Ausgabe
		$info = db_fetch_assoc(db_query('SELECT * FROM `prefix_wars` WHERE `status` = 3 AND `gegner` = "'.$name.'" ORDER BY `datime` DESC'),0);
		$tpl->set_ar_out($info,3);
		$i=0; $o=0;
		$gesmaps = db_result(db_query('SELECT COUNT(`map`) FROM `prefix_warmaps` LEFT JOIN `prefix_wars` ON `prefix_warmaps`.`wid` = `prefix_wars`.`id` WHERE `status` = "3" AND `gegner` = "'.$name.'"'),0);	
		$mapinfos = db_query('SELECT `map`, COUNT(`map`) as anz FROM `prefix_warmaps` LEFT JOIN `prefix_wars` ON `prefix_warmaps`.`wid` = `prefix_wars`.`id` WHERE `status` = "3" AND `gegner` = "'.$name.'" GROUP BY `map` ORDER BY `anz` DESC, `map` ASC');
		# Maps
		while ($m = db_fetch_assoc($mapinfos)) {
			$o++; 
			$m['class'] = ($o % 2) ? 'Cnorm' : 'Cmite' ;
			$m['mapname'] = $m['map'];
			$m['mapanz'] = $m['anz'];
			$m['mapbalken'] = get_colbar($m['anz'],$gesmaps,'blue');
			$tpl->set_ar_out($m,4);
		}
		$tpl->out(5);
		# Spiele
		while ($r = db_fetch_assoc($erg)) {
			$i++; 
			$r['class'] = ($i % 2) ? 'Cnorm' : 'Cmite' ;
			# Edit-Link Admin
			if (has_right(-8, 'wars')) {
				$r['edit'] ='&nbsp;&nbsp;<a title="Match bearbeiten" target="_blank" href="admin.php?wars-last&pkey='.$r['id'].'"><img src="include/images/bars/edit.png" border="0"></a>';
			} else {
				$r['edit'] ='';
			}
			$r['balken'] = get_ergbar ($r['owp'],$r['opp']);
			$r['wlpname'] = wlpname($r['wlp']);
			$tpl->set_ar_out($r,6);
		}
		$tpl->out(7);
	}
# Anzeige Liste
} else {
	# Header
	$title = $allgAr['title'].' :: Gegner Statistik';
	$hmenu = 'Gegner Statistik';
	$design = new design ( $title , $hmenu, 1); 
	$design->header();
	$tpl = new tpl ( 'gegner.htm' );  
	$limit = 30;  // Limit
	# Filter
	if($menu->exists('filtername')) {
		$page = ($menu->getA(3) == 'p' ? $menu->getE(3) : 1);
		$filtername = escape($menu->get(2), 'string');
	} elseif($menu->exists('letter')) {
		$page = ($menu->getA(3) == 'p' ? $menu->getE(3) : 1);
	} else {
		$page = ($menu->getA(1) == 'p' ? $menu->getE(1) : 1);
	}
	$anfang = ($page - 1) * $limit;
	if(isset($_GET['filtername']) AND !empty($_GET['filtername'])) {
		$filtername = escape($_GET['filtername'], 'string');
	}
	# Definierung Letter
	$allowed = array('1','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','extra');
	$extra = array('1' => '0-9', 'extra' => '#');
	$letter = in_array($menu->get(2), $allowed) ? $allowed[array_search($menu->get(2), $allowed)] : false;
	$abc ='';
	foreach($allowed as $val) { 
		$promptVal = array_key_exists($val, $extra) ? $extra[$val] : strtoupper($val);
		$class = (isset($class) && $class == 'Cmite') ? 'Cnorm' : 'Cmite' ;
		$abc .= '<a class="'.( $val == $letter ? 'Chead' : $class ).'" style="padding:2px 3px" href="index.php?gegner-letter-'.$val.'">'.( $val == $letter ? $promptVal : $promptVal ).'</a>';      
	}
	$abc .= '<a class="'.( empty($letter) ? 'Chead' : 'Cmite' ).'" style="padding:2px 3px" href="index.php?gegner">ALLE</a>';
	# Suchstring
	if(!empty($filtername)) {
		$sql_search = "`prefix_wars`.`gegner` LIKE '%".$filtername."%'";
		$mpl_link = '?gegner-filtername-'.$filtername;
	} elseif($menu->exists('letter') and $letter != false ) {
		if (is_numeric($letter)) {
			$sql_search = "LEFT(`prefix_wars`.`gegner`, 1) REGEXP '[[:digit:]]'";
		} elseif($letter == 'extra') {
			$sql_search = "LEFT(`prefix_wars`.`gegner`, 1) NOT REGEXP '[[:alnum:]]'";            
		} else {
			$sql_search = "LOWER( LEFT(`prefix_wars`.`gegner`, 1) ) = '".($letter)."'";    
		}
		$mpl_link = '?gegner-letter-'.$letter;
	} else {
		$sql_search = "";
		$mpl_link = '?gegner';
	}
	# Abfrage
	$sql_anz = db_num_rows(db_query("SELECT * FROM `prefix_wars` ".(strlen($sql_search) == "0" ? "" : "WHERE ".$sql_search)." GROUP BY `gegner`"),0);
	$sql_search = strlen($sql_search) == "0" ? "WHERE `status` = 3" : sprintf("WHERE %s AND `status` = 3", $sql_search); 
	$MPL = db_make_sites ($page , $sql_search , $limit , $mpl_link , 'wars' , $sql_anz );
	$tpl->set_ar_out(array('SITELINK' => $MPL, 'ABC' => $abc), 0);
	$q = sprintf("SELECT `gegner`, `tag`, COUNT(*) as anz, SUM(`owp`) as pktwir, SUM(`opp`) as pktgegner FROM `prefix_wars` %s GROUP BY `gegner` ORDER BY `gegner` ASC LIMIT %d,%d", $sql_search , $anfang, $limit);
	$erg = db_query($q);
	# Ausgabe
	while($row = db_fetch_object($erg)) {
		$class = (isset($class) && $class == 'Cmite') ? 'Cnorm' : 'Cmite' ;
		$ar = array (
			'CLASS'		=> $class,
			'NAME' 		=> '<span title="' . $row->gegner . '">' . ((strlen($row->gegner)<13) ? $row->gegner : substr($row->gegner,0,10).'...') . '</span>',
			'LINKNAME' 	=> $row->gegner,
			'TAG'		=> $row->tag,
			'ANZ'		=> $row->anz,
			'WIR'		=> str_repeat('&nbsp;',3-strlen($row->pktwir)).$row->pktwir,
			'GEGNER'	=> str_repeat('&nbsp;',3-strlen($row->pktgegner)).$row->pktgegner,
			'BALKEN'	=> get_ergbar ($row->pktwir,$row->pktgegner)
		);
		$tpl->set_ar_out($ar,1);
	}
	$filtername = isset($filtername) ? $filtername : '';  
	$tpl->set_out('filtername',$filtername,2);
}
# Ende
$design->footer();
?>