<?php 
#   Modul:			Design-Editor für Ilch 1.1 O
#   Copyright by: 	Felix Hohlwegler
#   Support: 		www.felix-hohlwegler.de
# 	Version 		1.4.1
#	Datum:			13.05.2013


$tpl = new tpl ('designedit', 1);

$design = new design ( 'Admins Area', 'Admins Area', 2 );
$design->header();

defined ('main') or die ( 'no direct access' );
defined ('admin') or die ( 'only admin access' );

#Datenbankverbindung
require_once('include/includes/config.php');
require_once('include/includes/func/db/mysql.php');
db_connect();


#------------------------------------------------------
# Security Erweiterung
#------------------------------------------------------
$sql = 'SELECT * FROM prefix_designeditsecurity WHERE id = 1';
$getsecmethod = db_query($sql);

#ausgabe Tags in Liste
while ($row = db_fetch_object($getsecmethod) ) {
  $security = $row->securitymethod;
}

$phpallowed = $security; // Standardwert False 


#------------------------------------------------------
# designs Suchen
#------------------------------------------------------
# Pfad definieren
$pfad = '';
$pfad = 'include/designs';

$copy = '';
$delete = '';

# Prüfung welche aktionen ausgeführt werden sollen + 
if ($menu->get(1) == 'delete') {
	$delete = 1;
	$deletedesign = $menu->get(2);
	
	$delpath = $pfad."/".$deletedesign;
	
	#Design löschen
	deletedesign($delpath);	
} else if ($menu->get(1) == 'filedel'){
	# gewähltes design auslesen
	$chosendesign = $menu->get(2);
	# gewählte Datei auslesen
	$chosenfile = $menu->get(3);
	
	#Datei Löschen
	delfile($pfad, $chosendesign, $chosenfile);
	
} else {
	# gewählte Datei auslesen
	$chosenfile = base64_decode($menu->get(2));
	# gewähltes design auslesen
	$chosendesign = $menu->get(1);
	
	#Datei In editor Laden
	if ($chosenfile != ""){
		loadfile($chosenfile, $chosendesign, $pfad);	
	}
}

#------------------------------------------------------
# Dateianlegen
#------------------------------------------------------
if (!empty($_POST['newfile'])) {
	# Pfad Auslesen
	$designwahl = $_POST['design'];
	# Dateiname lesen
	$file = $_POST['file'];
	
	$savepath = $pfad."/".$designwahl."/".$file;
	
	if (!file_exists($savepath)) {	
		# Datei öffnen
		$fh = fopen($savepath, 'w');
		# Datei Schließen
		fclose($fh);
	} else {
		echo"
			<script>
				alert('Datei bereits vorhanden, Bitte anderen Dateinamen w&auuml;hlen');
			</script>";
	}
} 
#------------------------------------------------------
# Design anlegen
#------------------------------------------------------
if (!empty($_POST['newdesign'])) {
	# Code einlese
	$designname = $_POST['designname'];
	$savepath = $pfad."/".$designname;
	
	if (!file_exists($savepath)) {		
		# Ordner anlegen
		mkdir($savepath);
	} else {
		echo"
			<script>
				alert('Design bereits vorhanden, Bitte w&auml;hlen Sie einen anderen Designnamen');
			</script>";
	}
}
#------------------------------------------------------
# Datei Kopieren
#------------------------------------------------------
if(!empty($_POST['copy'])){
	
	$newPath = $pfad."/".$_POST['design_zwei'];
	$oldFile = $_POST['oldfile'];
	$newFile = $newPath."/".$_POST['newfilename'];

	if (!copy($oldFile,$newFile)) {
		echo "Der Kopiervorgang schlug Fehl\n";
	}
}
#------------------------------------------------------
# Design löschen
#------------------------------------------------------
function deletedesign($pfad) {
	if (is_dir($pfad) === true) { 
        $files = array_diff(scandir($pfad), array('.', '..')); 
         
        // Durch die vorhandenen Dateien laufen 
        foreach ($files as $file) {
          deletedesign(realpath($pfad).'/'.$file); 
        } 
        return rmdir($pfad); 
    } 
     
    // Datei entfernen 
    else if (is_file($pfad) === true) { 
        return unlink($pfad); 
    } 
    return false; 
}
#------------------------------------------------------
# Datei löschen
#------------------------------------------------------
function delfile($pfad, $chosendesign, $chosenfile){
	
	
	$fullfilename = filenamerep(base64_decode($chosenfile));
	$filedelete = $pfad."/".$chosendesign."/".$fullfilename;
	unlink($filedelete);
}

#------------------------------------------------------
# Designs Suchen
#------------------------------------------------------

# Ordner öffnen
$dir = opendir($pfad);
# Array erstellen
$items = array();
 
# Ordner auslesen
while ($ordner = readdir($dir)){
	# Datei im Array hinzuf?gen
	if (!is_dir($ordner)){
		# substring bilden
		$sub = substr($ordner,0,$length);
		if ($filename == $sub) {
			$items[] = $ordner;
		}
	}
}
closedir($dir);

#------------------------------------------------------
# Ausgewähltes Design durchsuchen
#------------------------------------------------------
function readdesign($chosendesign, $pfad, $designfiles){
	# Pfad zusammensetzen
	$designpfad = $pfad."/".$chosendesign;
	
	#Ordner öffnen
	$dir = opendir($designpfad);
	# Ordner auslesen
	while ($ordner = readdir($dir)){
		# Datei im Array hinzufügen
		if ($ordner != "." AND $ordner != ".." AND !is_dir($designpfad . "/" . $ordner) ){
			# substring bilden
			$sub = substr($ordner,0,$length);
			if ($filename == $sub) {
				$designfiles[] = $ordner;				
			}
		}
	}
	closedir($dir);
	
	#Prüfen ob Dateien vorhanden sind, wenn ja ausgeben
	if( count($designfiles) == 0) {
		echo "<p>Dieses Design beinhaltet noch keine Dateien</p>";
	} else {
		echo"<tr>
				<th style='color: white;'>Datei</th>
				<th></th>
				<th></th>
				<th></th>
			</tr>";
		
		# Ausgabe Design Dateien
		for($j=0; $j < count($designfiles); $j++){
			echo"
			<tr>
				<td class='Cnorm'>".$designfiles[$j]."</td>
				<td class='Cnorm'><a href='?designedit-".$chosendesign."-".base64_encode($designfiles[$j])."'id='file'".$j."' title='Bearbeiten'><img src='include/images/icons/edit.gif' alt='Löschen' /></a></a></td>
				<td class='Cnorm'><a href='javascript:displaycopy(\"".$chosendesign."\",\"".$designfiles[$j]."\");' title='Kopieren'><img src='include/images/icons/admin/copy.png' alt='Kopieren' /></a></td>
				<td class='Cnorm'><a href='javascript:deletefile(\"".$chosendesign."\",\"".base64_encode($designfiles[$j])."\");'title='Löschen'><img src='include/images/icons/del.gif' alt='Löschen' /></a></td>
			</tr>";
		}
	}
}

#------------------------------------------------------
# Ausgewählte Datei in editor Laden
#------------------------------------------------------
function loadfile($chosenfile, $chosendesign, $pfad) {
	# Globale Variablen Deklaration
	global $filestring, $fullfilename, $file;
    
	$fullfilename = filenamerep($chosenfile);
	//Datei Pfad
	$file = $pfad."/".$chosendesign."/".$fullfilename;
	//Datei Einlesen
	$filestring = implode("", file ($file));
}

#------------------------------------------------------
# Dateiname wieder zusammen setzen
#------------------------------------------------------
function filenamerep($chosenfile){
	//Länge des Ausgewählten Files	
	$length = strlen($chosenfile);
	//Datei Endung abspalten
	if(strpos($chosenfile,".")!==false){
		$ftype =substr($chosenfile, strrpos ( $chosenfile, '.' )+1);
		$fname = substr($chosenfile, 0, strrpos($chosenfile,'.'));
		$fullfilename = $fname.".".$ftype;
	} else {
	$fullfilename = $chosenfile;
	}
	return $fullfilename;
}
#------------------------------------------------------
# Speichern
#------------------------------------------------------
if (!empty($_POST['save'])) {
	# Pfad Auslesen
	$path = $_POST['path'];
	# Code einlesen
	$code = $_POST['code'];
	
	// Filtern PHP löschen
	if(strpos($code,"<?") !== true and $phpallowed != "true"){
	$zeichen = array ("<?=", "<?php", "<?PHP", "?>");
	$ersetzen = array ();
		for ($x = 0; $x < 4; $x++ ) {
			$code = str_replace ($zeichen[$x], $ersetzen[$x], $code);
		}
		$code ='<!-- PHP Code ist nicht Zul&auml;ssig'.htmlspecialchars($code). ' -->';
	}
	# Datei öffnen
	$fh = fopen($path, 'w');
	# Datei überschreiben
	fwrite($fh, $code);
	# Datei Schließen
	fclose($fh);
}

#------------------------------------------------------
# Designs in Dropdown Liste ausgeben
#------------------------------------------------------
function loadDesignsinSelect($items){
	echo '<select name="design">';
		for($k=0; $k < count($items); $k++){
			echo "<option>".$items[$k]."</option>";
		}
	echo '</select>';
}
function loadDesignsinSelectCopy($items){
	echo '<select name="design_zwei">';
		for($k=0; $k < count($items); $k++){
			echo "<option>".$items[$k]."</option>";
		}
	echo '</select>';
}
#################################################################
# AUSGABE 
#################################################################

$tpl->out(0);

##Ausgabe der Designnamen
echo"<div class='left' >";
for($i=0; $i < count($items); $i++){
	echo"
   <p class='msg_head' id='".$items[$i]."'>".$items[$i]."</p>
   <div class='msg_body'> <table class='border' cellpadding='3' cellspacing='1' border='0'>";
		# Design Dateien Suchen
		readdesign($items[$i], $pfad, $designfiles);
   echo "</table>";
   echo"<br><a href='?designedit-delete-".$items[$i]."'>Design komplett l&ouml;schen</a>";
   echo "</div>";
}
echo "</div>";

$tpl->out(1);

loadDesignsinSelect($items);
$tpl->out(2);

loadDesignsinSelectCopy($items);
$tpl->out(3);

##String in Editor Pasten
$tpl->set('FILE',$fullfilename);
$tpl->set('PATH',$file);
$tpl->set('CODE',$filestring);
$tpl->out(4);
$tpl->out(5);

$design->footer();
?>