<?php 
#   Copyright by: jihi
#   Support: www.ilch.de


defined ('main') or die ( 'no direct access' );
defined ('admin') or die ( 'only admin access' );

require_once("include/includes/class/xajax.inc.php");

$xajax = new xajax();

function save( $filename, $content, $encoding)
{
  $objResponse = new xajaxResponse();
  $objResponse->setCharacterEncoding('ISO-8859-1');
  
  if ( $encoding == 'ansi') {
    $content = utf8_decode( $content );
    //$filename = utf8_decode( $filename );
  }
  
  #$objResponse->alert( "filename: ".$filename."\n". $content );
  if ( is_writable( $filename ) OR !file_exists( $filename ) ) {
    if (!$handle = fopen($filename, "wb")) {
      $objResponse->alert( 'Datei konnte nicht geffnet werden' );
    }
    if (!fwrite($handle, $content)) {
        $objResponse->alert( 'Inhalt konnte nicht geschireben werden' );
    }
    fclose($handle);
  } else {
      $objResponse->alert( 'Datei ist schreibgeschtzt' );
  }    

  return $objResponse;
}

function load( $filename, $encoding )
{
  $objResponse = new xajaxResponse();
  if( $encoding == 'ansi'){
    $objResponse->setCharacterEncoding('ISO-8859-1');
  }
  
  if( file_exists( $filename ) ){
    if( is_readable( $filename ) ){
      $contents = file_get_contents( $filename );
      $title = basename( $filename );
      $extension = @substr( $title, strrpos( $title, '.') + 1 );
      $extension = strtolower( $extension );
      if ( $extension == 'htm') {$extension = 'html';}
      if ( !in_array( $extension, array('php', 'html', 'javascript', 'sql') ) ) {
        $extension = 'php';
      }
      $contents = str_replace(array('\\',"\r\n","\n",'"'), array('\\\\','\n','\n', '\"'), $contents);
      $script = 'editAreaLoader.openFile("editarea", {id: "'.$filename.'", text: "'.$contents.'", syntax: "'.$extension.'", title: "'.$title.'"});';
      $objResponse->script( $script );
      if( !is_writable ){
        $objResponse->alert( 'Datei ist schreibgeschtzt' );
      }
    } else {
      $objResponse->alert( 'Datei ist nicht lesbar' );
    }
  } else {
      $title = basename( $filename );
      $script = 'editAreaLoader.openFile("editarea", {id: "'.$filename.'", text: "", syntax: "php", title: "'.$title.'"});';
      $objResponse->script( $script );
      if( !is_writable ){
        $objResponse->alert( 'Datei ist schreibgeschtzt' );
      }    
  }
  //return the  xajaxResponse object
  return $objResponse;
}

function browse( $path = './')
{
  $objResponse = new xajaxResponse();
  
  $path = str_replace('\\', '/', $path);
  if( substr($path, -3) == '../' ){
    $parts = explode( '/', $path );
    if( count( $parts ) > 3 ){
      $path = join( '/', array_slice( $parts, 0, -3 ) ) . '/';
    }
  }
  $files=array();
  $directories=array();
  $handle = @opendir($path);
  while (false !== ($file = readdir($handle))) {
    if ($file !=".." AND $file != "."){
      if(is_file($path.$file)){
        $files[]=$file;
      }else if(is_dir($path.$file)){
        $directories[]=$file;
      }
  	}
	}
	closedir($handle);
  sort($directories);
  sort($files);
  $html = '<table border="1" width="100%">';
  $html .= '<tr><td onclick="xajax_browse(\''.$path.'../\')">..</td>';
  foreach ($directories as $dir){
    $html .= '<tr><td onclick="xajax_browse(\''.$path.$dir.'/\')">'.$dir.'</td>';
    $html .= '<td></td>';
    //$html .= '<td><img src="include/images/icons/reload.gif" title="rename" alt="rename" onclick=""></td>';
    //$html .= '<td><img src="include/images/icons/del.gif" title="delete" alt="delete" onclick=""></td>';
    $html .= '</tr>';
  }
  foreach ($files as $file){
    $html .= '<tr><td onclick="document.getElementById(\'ea_load_filename\').value=\''.$path.$file.'\';">'.$file.'</td>';
    $size=filesize($path.$file);
    $e="b";
    if($size > 1024){$size=round($size / 1024 * 100) / 100;$e='kb';}
    if($size > 1024){$size=round($size / 1024 * 100) / 100;$e='Mb';}
    if($size > 1024){$size=round($size / 1024 * 100) / 100;$e='Gb';}
    $html .= '<td>'.$size.' '.$e.'</td>';
    
    //$html .= '<td><img src="include/images/icons/edit.gif" title="edit" alt="edit" onclick=""></td>';
    //$html .= '<td><img src="include/images/icons/pfeila.gif" title="move" alt="move" onclick=""></td>';
    //$html .= '<td><img src="include/images/icons/reload.gif" title="rename" alt="rename" onclick=""></td>';
    //$html .= '<td><img src="include/images/icons/del.gif" title="delete" alt="delete" onclick=""></td>';
    $html .= '</tr>';
  }
  $html .= '</table>';
  $objResponse->assign("ea_filebrowser", "innerHTML", $html);
  //return the  xajaxResponse object
  return $objResponse;
}

$xajax->registerFunction("load");
$xajax->registerFunction("save");
$xajax->registerFunction("browse");

$xajax->processRequest();

if( isset( $_GET['install'] ) ){
  if( db_num_rows(db_query("SELECT url FROM `prefix_modules` WHERE url = 'editarea'")) == 0 ){
    db_query("INSERT INTO `prefix_modules` (`url`,`name`,`gshow`,`ashow`,`fright`) VALUES ('editarea','EditArea', 0, 1, 0)");
  }
}
if( isset( $_GET['uninstall'] ) ){
  db_query("DELETE FROM `prefix_modules` WHERE `url` = 'editarea'");
}

$design = new design ( 'Admins Area', 'Admins Area', 2 );
$design->addheader($xajax->getJavascript());
$design->header();

$tpl = new tpl('editarea', 1);

$tpl->out(0);

$design->footer();
?>
