<?php

/**
 * @copyright Ilch 2
 * @package ilch
 */

namespace Modules\Awards\Config;

class Config extends \Ilch\Config\Install
{
    public $config = [
        'key' => 'awards',
        'version' => '1.12.2',
        'icon_small' => 'fa-solid fa-trophy',
        'author' => 'Veldscholten, Kevin',
        'link' => 'https://ilch.de',
        'official' => true,
        'languages' => [
            'de_DE' => [
                'name' => 'Auszeichnungen',
                'description' => 'Hier können Auszeichnungen an Benutzer oder Teams verliehen werden.',
            ],
            'en_EN' => [
                'name' => 'Awards',
                'description' => 'Here you can award users or teams an award.',
            ],
        ],
        'ilchCore' => '2.2.13',
        'phpVersion' => '7.4'
    ];

    public function install()
    {
        $this->db()->queryMulti($this->getInstallSql());

        $databaseConfig = new \Ilch\Config\Database($this->db());
        $databaseConfig->set('awards_userNotification', 1);
    }

    public function uninstall()
    {
        $this->db()->drop('awards_recipients', true);
        $this->db()->drop('awards', true);

        $databaseConfig = new \Ilch\Config\Database($this->db());
        $databaseConfig->delete('awards_userNotification');
    }

    public function getInstallSql(): string
    {
        return 'CREATE TABLE IF NOT EXISTS `[prefix]_awards` (
                  `id` INT(11) NOT NULL AUTO_INCREMENT,
                  `date` DATE NOT NULL,
                  `rank` INT(11) NOT NULL,
                  `image` VARCHAR(255) NOT NULL,
                  `event` VARCHAR(100) NOT NULL,
                  `url` VARCHAR(150) NOT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1;

                CREATE TABLE IF NOT EXISTS `[prefix]_awards_recipients` (
                    `award_id` INT(11) NOT NULL,
                    `ut_id` INT(11) NOT NULL,
                    `typ` TINYINT(1) NOT NULL,
                    INDEX `FK_[prefix]_awards_recipients_[prefix]_awards` (`award_id`) USING BTREE,
                    CONSTRAINT `FK_[prefix]_awards_recipients_[prefix]_awards` FOREIGN KEY (`award_id`) REFERENCES `[prefix]_awards` (`id`) ON UPDATE NO ACTION ON DELETE CASCADE
                ) ENGINE=InnoDB COLLATE=utf8mb4_unicode_ci;';
    }

    public function getUpdate(string $installedVersion): string
    {
        switch ($installedVersion) {
            case "1.0":
                // no break
            case "1.1":
                $this->db()->query('ALTER TABLE `[prefix]_awards` ADD `image` VARCHAR(255) NOT NULL AFTER `rank`;');
                // no break
            case "1.2":
                // no break
            case "1.3":
                // no break
            case "1.4":
                // Convert table to new character set and collate
                $this->db()->query('ALTER TABLE `[prefix]_awards` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;');
                // no break
            case '1.5.0':
                // no break
            case '1.6.0':
                // no break
            case '1.7.0':
                // no break
            case '1.8.0':
                $this->db()->query("UPDATE `[prefix]_modules` SET `icon_small` = 'fa-solid fa-trophy' WHERE `key` = 'awards';");
                // no break
            case '1.9.0':
                // Create new table awards_recipients.
                $this->db()->query('CREATE TABLE IF NOT EXISTS `[prefix]_awards_recipients` (
                    `award_id` INT(11) NOT NULL,
                    `ut_id` INT(11) NOT NULL,
                    `typ` TINYINT(1) NOT NULL,
                    INDEX `FK_[prefix]_awards_recipients_[prefix]_awards` (`award_id`) USING BTREE,
                    CONSTRAINT `FK_[prefix]_awards_recipients_[prefix]_awards` FOREIGN KEY (`award_id`) REFERENCES `[prefix]_awards` (`id`) ON UPDATE NO ACTION ON DELETE CASCADE
                ) ENGINE=InnoDB COLLATE=utf8mb4_unicode_ci;');

                // Copy existing recipients in chunks of 25 recipients at a time to the new table.
                $existingRecipientsRows = $this->db()->select(['id', 'ut_id', 'typ'])
                    ->from(['awards'])
                    ->execute()
                    ->fetchRows();

                $existingRecipients = [];
                foreach ($existingRecipientsRows as $recipientsRow) {
                    $existingRecipients[] = [$recipientsRow['id'], $recipientsRow['ut_id'], $recipientsRow['typ']];
                }

                $existingRecipients = array_chunk($existingRecipients, 25);
                foreach ($existingRecipients as $existingRecipientsChunk) {
                    $this->db()->insert('awards_recipients')
                        ->columns(['award_id', 'ut_id', 'typ'])
                        ->values($existingRecipientsChunk)
                        ->execute();
                }

                // Delete no longer needed columns of the awards table
                $this->db()->query('ALTER TABLE `[prefix]_awards` DROP COLUMN `ut_id`, DROP COLUMN `typ`');
                // no break
            case '1.10.0':
                // no break
            case '1.10.1':
                // no break
            case '1.11.0':
                // Enable notification of users if they receive an award by default.
                $databaseConfig = new \Ilch\Config\Database($this->db());
                $databaseConfig->set('awards_userNotification', 1);
                // no break
            case '1.12.0':
                // no break
            case '1.12.1':
                // no break
        }

        return '"' . $this->config['key'] . '" Update-function executed.';
    }
}
